<?php
class SiteSearch {
    public $bodyRegex = '';
    protected $seen = array();
    
    
    public function searchDir($dir) {
        // Tablica przeznaczona do przechowywania wyszukanych stron
        $pages = array();

        // Tablica przeznaczona do przechowywania katalogw wymagajcych 
        // rekurencyjnego sprawdzenia
        $dirs = array();

        // Oznaczenie katalogu jako sprawdzonego (by nie by analizowany powtrnie)
        $this->seen[realpath($dir)] = true;
    
        try {
            foreach (new RecursiveIteratorIterator(
            new RecursiveDirectoryIterator($dir)) as $file) {
                if ($file->isFile() && $file->isReadable() &&
                (! isset($this->seen[$file->getPathname()]))) {
                    // Oznaczenie elementu jako sprawdzonego, by nie
                    // by analizowany powtrnie
                    $this->seen[$file->getPathname()] = true;
                    
                    // Pobranie treci pliku i zapisanie w zmiennej $text
                    $text = file_get_contents($file->getPathname());

                    // Czy szukany cig znajduje si pomidzy ogranicznikami 
                    // treci dokumentu?
                    if (preg_match($this->bodyRegex,$text)) {

                    // Utworzenie wzgldnego identyfikatora URI przez usunicie
                    // z penej cieki fragmentu zwizanego z gwnym katalogiem
                    // dokumentw.
                    $uri = substr_replace($file->getPathname(),'',0,strlen
                    ($_SERVER['DOCUMENT_ROOT']));

                    // Jeli strona ma tytu, trzeba go wyodrbni
                    if (preg_match('#<title>(.*?)</title>#Sis',$text,$match)) {
                        // Dodanie tytuu i identyfikatora URI do tablicy $pages
                        array_push($pages,array($uri,$match[1]));
                    } else {
                        // W przeciwnym przypadku jako tytu zostanie wykorzystana 
                        // warto URI
                        array_push($pages,array($uri,$uri));
                    }
                }
                }
            }
        } catch (Exception $e) {
            // Problem z otwarciem katalogu.
        }
        return $pages;
    }
}

// Funkcja pomocnicza, sortujca strony w porzdku alfabetycznym wzgldem tytuu
function by_title($a,$b) {
        return ($a[1] == $b[1]) ?
               strcmp($a[0],$b[0]) :
               ($a[1] > $b[1]);
}

// Powoanie obiektu SiteSearch do rozpoczcia wyszukiwania
$search = new SiteSearch();

// Tablica przechowujca informacje o stronach speniajcych kryteria wyszukiwania
$matching_pages = array();
// Podkatalogi gwnego katalogu dokumentw objte procedur wyszukiwania
$search_dirs = array('sports','movies','food');
// Wyraenie regularne stosowane do przeszukiwania plikw. Modyfikator wzorca "S"
// stanowi informacj dla mechanizmu PCRE o koniecznoci "zapoznania si" z wyraeniem
// w celu zwikszenia efektywnoci dziaania.
$search->bodyRegex = '#<body>(.*' . preg_quote($_REQUEST['term'],'#'). 
                     '.*)</body>#Sis';

// Dodanie plikw (speniajcych kryteria wyszukiwania) z danego katalogu do 
// stron zapisanych w zmiennej $matching
foreach ($search_dirs as $dir) {
    $matching_pages = array_merge($matching_pages,
                      $search->searchDir($_SERVER['DOCUMENT_ROOT'].'/'.$dir));
}

if (count($matching_pages)) {
    // Posortowanie stron wzgldem tytuu
    usort($matching_pages,'by_title');
    print '<ul>';
    // Wywietlenie kadego tytuu wraz z odsyaczem do strony
    foreach ($matching_pages as $k => $v) {
        print sprintf('<li> <a href="%s">%s</a>',$v[0],$v[1]);
    }
    print '</ul>';
} else {
    print 'Nie znaleziono adnych stron speniajcych kryteria.';
}
?>
